
<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$location = "Wilderness, South Africa";
$apiKey = "YOUR_API_KEY";
$apiUrl = "http://api.openweathermap.org/data/2.5/forecast?q=" . urlencode($location) . "&appid=" . $apiKey . "&units=metric";

$response = file_get_contents($apiUrl);
$data = json_decode($response, true);

if ($data === null) {
    echo "Error decoding JSON response: " . json_last_error_msg();
    exit;
}

if (isset($data['cod']) && $data['cod'] !== '200') {
    echo "Error fetching weather data: " . $data['message'];
    exit;
}

$forecast = array();

foreach ($data['list'] as $dayData) {
    $date = date('l', $dayData['dt']);
    $condition = $dayData['weather'][0]['main'];
    $temperature = round($dayData['main']['temp']) . "°C";
    $waveHeight = "N/A";
    $surfRating = "N/A";

    $forecast[] = array(
        'day' => $date,
        'condition' => $condition,
        'temperature' => $temperature,
        'wave_height' => $waveHeight,
        'surf_rating' => $surfRating
    );
}

echo "<h1>Surf Forecast for $location</h1>";
echo "<table style='width: 100%; border-collapse: collapse; font-family: Arial, sans-serif;'>";
echo "<tr style='background-color: #0066cc; color: white;'><th>Day</th><th>Condition</th><th>Temperature</th><th>Wave Height</th><th>Surf Rating</th></tr>";

foreach ($forecast as $day) {
    echo "<tr style='background-color: #e6f2ff;'>";
    echo "<td style='padding: 10px;'>{$day['day']}</td>";
    echo "<td style='padding: 10px;'>{$day['condition']}</td>";
    echo "<td style='padding: 10px;'>{$day['temperature']}</td>";
    echo "<td style='padding: 10px;'>{$day['wave_height']}</td>";
    echo "<td style='padding: 10px;'>{$day['surf_rating']}</td>";
    echo "</tr>";
}

echo "</table>";

?>